/**
 *   Copyright 2000, 2001, 2002, and 2003 by Mark Watson.  All rights reserved.
 */

package S02;

import java.io.*;
import java.util.*;
import java.util.zip.*;

public class GZIPexample {

    public static void main(String[] args) throws IOException {
        String s = "test data\nfor GZIP demo.\n";
        FileOutputStream fout = new FileOutputStream("test.gz");
        GZIPOutputStream out = new GZIPOutputStream(fout);
        out.write(s.getBytes());
        out.close();

        FileInputStream fin = new FileInputStream("test.gz");
        GZIPInputStream in = new GZIPInputStream(fin);
        byte[] bytes = new byte[2048];
        while (true) {
            int count = in.read(bytes, 0, 2048);
            if (count < 1) break;
            String s2 = new String(bytes, 0, count);
            System.out.println(s2);
        }
        in.close();
    }
}
