package S01;

import java.util.Vector;
import java.io.*;

public class FileUtils {

    private FileUtils() {  // no class instances allowed
    }

    static public void main(String[] args) throws Exception {
        File in = new File("./temp123");
        in.createNewFile();
        FileUtils.copyFilePath(in, new File("./temp234"));
        deleteFilePath(new File("./temp123"));
        Vector non_dir_files = FileUtils.getNonDirFiles("./S01");
        Vector txt_java_files = FileUtils.getFiles("./S01", new String[]{".txt", ".java"});
        Vector all_files = FileUtils.getFiles("./S01");
    }

    static public Vector getNonDirFiles(String path) throws IOException {
            File dir = new File(path);
            AllNonDirFileFilter filter = new AllNonDirFileFilter();
            String[] ss = dir.list(filter);
            if (ss == null || ss.length == 0) return new Vector(1);
            Vector v = new Vector(ss.length);
            for (int i = 0; i < ss.length; i++) {
                v.addElement(path + fileSeparator + ss[i]);
            }
            return v;
    }

    static public Vector getFiles(String path, String[] extensions) throws IOException {

            File dir = new File(path);
            LocalFileFilter filter = new LocalFileFilter(extensions);
            String[] ss = dir.list(filter);
            if (ss == null || ss.length == 0) return new Vector(1);
            Vector v = new Vector(ss.length);
            for (int i = 0; i < ss.length; i++) {
                v.addElement(path + fileSeparator + ss[i]);
            }
            return v;
    }

    static public Vector getFiles(String path) throws IOException {

            File dir = new File(path);
            String[] ss = dir.list();
            if (ss == null || ss.length == 0) return new Vector(1);
            Vector v = new Vector(ss.length);
            for (int i = 0; i < ss.length; i++) {
                v.addElement(path + fileSeparator + ss[i]);
            }
            return v;
    }

    static class LocalFileFilter implements FilenameFilter {
        public LocalFileFilter(String[] extensions) {
            this.extensions = extensions;
        }

        private String[] extensions;

        final public boolean accept(File dir, String name) {
            for (int i = 0; i < extensions.length; i++) {
                if (name.endsWith((String) (extensions[i]))) {
                    return true;
                }
            }
            return false;
        }
    }

    static class AllNonDirFileFilter implements FilenameFilter {
        public AllNonDirFileFilter() {
        }

        final public boolean accept(File dir, String name) {
            //System.out.println("dir="+dir+", name="+name);
            File ff = new File(dir.toString() + fileSeparator + name);
            if (ff.isDirectory()) return false;
            return true;
        }
    }

    static class AllDirFileFilter implements FilenameFilter {
        public AllDirFileFilter() {
        }

        final public boolean accept(File dir, String name) {
            //System.out.println("dir="+dir+", name="+name);
            File ff = new File(dir.toString() + fileSeparator + name);
            if (ff.isDirectory()) return true;
            return false;
        }
    }

    /**
     * Allows cross-platform compatibility.
     */
    public static final String fileSeparator = System.getProperty("file.separator");

    public static final void copyFilePath(File sourceFilePath, File destinationFilePath)
            throws IOException {
        FileInputStream sourceInputStream = null;
        FileOutputStream destinationInputStream = null;
        if (sourceFilePath.exists() == false) {
            throw new IOException("File not found: " + sourceFilePath);
        }

        if (sourceFilePath.canRead() == false) {
            throw new IOException("File can not be read: " + sourceFilePath);
        } else if (sourceFilePath.isDirectory()) {
            if (destinationFilePath.isFile()) {
                throw new IOException("Cannot copy directory " + sourceFilePath
                        + " to file " + destinationFilePath);
            }

            if (destinationFilePath.exists() == false) {
                destinationFilePath.mkdir();
            }
        } else if (sourceFilePath.isFile()) {
            if (destinationFilePath.exists() == false) {
                String parentDirectoryName = sourceFilePath.getParent();
                if (parentDirectoryName != null) {
                    File parentdir = new File(parentDirectoryName);
                    if (parentdir.exists() == false) {
                        parentdir.mkdir();
                    }
                }
            } else if (destinationFilePath.isDirectory()) {
                destinationFilePath = new File(destinationFilePath + File.separator + sourceFilePath);
            }
        }


        if (sourceFilePath.isDirectory()) {
            String[] fileList = sourceFilePath.list();

            for (int i = 0; i < fileList.length; i++) {
                String targetFile = fileList[i];
                String target = sourceFilePath + File.separator + targetFile;
                String targetDestination = destinationFilePath + File.separator + targetFile;

                if ((new File(target)).isDirectory()) {
                    copyFilePath(new File(target), new File(targetDestination));
                } else {
                    try {
                        byte[] buffer = new byte[2048];
                        sourceInputStream = new FileInputStream(target);
                        destinationInputStream = new FileOutputStream(targetDestination);
                        while (true) {
                            int readCount = sourceInputStream.read(buffer);
                            if (readCount == -1) {
                                break;
                            }
                            destinationInputStream.write(buffer, 0, readCount);
                        }
                    } finally {
                        if (sourceInputStream != null) {
                            try {
                                sourceInputStream.close();
                            } catch (IOException ignoreException) {
                            }
                        }
                        if (destinationInputStream != null) {
                            try {
                                destinationInputStream.close();
                            } catch (IOException ignoreException) {
                            }
                        }
                    }
                }
            }
        } else if (sourceFilePath.isFile()) {
            try {
                byte[] buffer = new byte[2048];
                sourceInputStream = new FileInputStream(sourceFilePath);
                destinationInputStream = new FileOutputStream(destinationFilePath);
                while (true) {
                    int readCount = sourceInputStream.read(buffer);
                    if (readCount == -1) {
                        break;
                    }
                    destinationInputStream.write(buffer, 0, readCount);
                }
            } finally {
                if (sourceInputStream != null) {
                    try {
                        sourceInputStream.close();
                    } catch (IOException ignoreException) {
                    }
                }
                if (destinationInputStream != null) {
                    try {
                        destinationInputStream.close();
                    } catch (IOException ignoreException) {
                    }
                }
            }
        }
    }


    public static final boolean deleteFilePath(File filePath) {
        System.out.println("deleteFile(" + filePath + ")");
        if (filePath == null) {
            return false;
        }

        if (filePath.isDirectory()) {
            String[] dirListing = filePath.list();

            // For each file/directory in listing, make recursive call.
            int len = dirListing.length;
            for (int i = 0; i < len; i++) {
                if (deleteFilePath(new File(filePath.toString() + fileSeparator + dirListing[i])) == false) {
                    // Break and return an error.
                    return false;
                }
            }
        }

        // Delete file or directory.
        if (filePath.delete() == false) {
            // Display message and return an error.
            System.out.println("Could not delete: " + filePath.getAbsolutePath());
            return false;
        }

        return true;
    }

}
