package demo.forms;


import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.*;

public final class LoginForm extends ActionForm {
    private String username = null;
    private String password = null;
    public String getUserName() {
		return (this.username);
    }
    public void setUserName(String username) {
        this.username = username;
    }
    public String getPassword() {
		return (this.password);
    }
    public void setPassword(String password) {
        this.password = password;
    }
    public ActionErrors validate(ActionMapping mapping,
                                 HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if ((username == null) || (username.length() < 1))
            errors.add("userName", new ActionError("error.bad.username"));
        if ((password == null) || (password.length() < 1))
            errors.add("password", new ActionError("error.bad.password"));
        return errors;
    }
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.username = null;
        this.password = null;
    }
}
