// File: tplot.h
//
// Description: This File contains the data structure/class definition for
//                        the TPlotClass.
//

#include "applib.h"

const int MAX_PLOTS = 8;

class TPlotClass {

// Pointer to the smart vector holding the X coordinate data:

double *x_coord;

// Pointers to the Y Coordinates for the plot(s):

double *y_coords[MAX_PLOTS];

// The number of points to plot:

int num_points;

// The number of active plots:

int num_plots;  // To a maximum of MAX_PLOTS.

char *my_title;

// Store the value of the pointer to the TAppWindow containing this plot:

TAppWindow *my_window;

// Private plot data:

int top, right, bottom, left;

int x_org, y_org;

double x_scale; // x_value * x_scale + x_org = x coordinate in my_window

double y_scale; // y_value * y_scale + y_org = y coordinate in my_window

double x_min, y_min, x_max, y_max;

// Calculate private scaling data:

void calc_data(double x_min, double x_max, double y_min, double y_max);


public:
    TPlotClass(TAppWindow *window, char *plot_title, double *x, double *y,
               int np,  int in_top, int in_right, int in_bottom, int in_left);
    TPlotClass(TAppWindow *window, char *plot_title, 
               double *x, double **y, int number_of_plots,
               int np, int in_top, int in_right, int in_bottom, int in_left);
    void plot();
    void rescale();
   ~TPlotClass();
};

