// File: tplotcp
//
// Description: This File contains the methods for the TPlotClass.
//

#include "tplot.h"


// Public methods:

void TPlotClass::calc_data(double x_min, double x_max, double y_min, double y_max)
{
    x_scale = 0.999 * ((double)(right - left )) / (x_max - x_min);
    y_scale = ((double)(bottom - top))/ (y_max - y_min);
    x_org = left;
    y_org = top;
}

TPlotClass::TPlotClass(TAppWindow *window, char *plot_title,
                       double *x, double *y, int np,  int in_top,
                       int in_right, int in_bottom, int in_left)
{
    // Copy the plot boundaries:
    top = in_top + 22;     right = in_right-3;
    bottom = in_bottom - 10;    left = in_left + 30;

    // Calculate the scaling data and plot origin:
    double MinX = 9999999.9;
    double MaxX = -MinX;
    for (int i=0; i<np; i++) {
        if (x[i] < MinX)  MinX  = x[i];
        if (x[i] > MaxX) MaxX = x[i];
    }
    double MinY = 9999999.9;
    double MaxY = -MinY;
    for (i=0; i<np; i++) {
        if (y[i] < MinY)  MinY  = y[i];
        if (y[i] > MaxY) MaxY = y[i];
    }

    x_min = MinX;  y_min = MinY; x_max = MaxX; y_max = MaxY;

    my_title = new char[strlen(plot_title)+1];
    strcpy(my_title, plot_title);

    for (int k=0; k<strlen(plot_title); k++) my_title[k] = plot_title[k];
    my_title[strlen(plot_title)] = '\0';
    calc_data(MinX, MaxX, MinY, MaxY);
    x_coord = x;
    y_coords[0] = y;
    num_plots = 1;
    num_points = np;
    my_window = window;
}

void TPlotClass::rescale()
{
    double MinX = 9999999.9;
    double MaxX = -MinX;
    for (int i=0; i<num_points; i++) {
        if (x_coord[i] < MinX)  MinX  = x_coord[i];
        if (x_coord[i] > MaxX) MaxX = x_coord[i];
    }
    double MinY = 9999999.9;
    double MaxY = -MinY;
    for (i=0; i<num_points; i++) {
        if (y_coords[0][i] < MinY)  MinY  = y_coords[0][i];
        if (y_coords[0][i] > MaxY) MaxY = y_coords[0][i];
    }
    x_min = MinX;  y_min = MinY; x_max = MaxX; y_max = MaxY;
    calc_data(MinX, MaxX, MinY, MaxY);
}

TPlotClass::TPlotClass(TAppWindow *window, char *plot_title, 
                       double *x, double **y, int number_of_plots,
                       int np, 
                       int in_top, int in_right, int in_bottom, int in_left)
{

    // Copy the plot boundaries:

    top = in_top;                  right = in_right;

    bottom = in_bottom;    left = in_left;

}

TPlotClass::~TPlotClass()
{

    delete my_title;
}

void TPlotClass::plot()
{

    my_window->erase_rect(top-20, right+10, bottom+24, left-30);


    // Frame the Plot:

    my_window->plot_rect(top, right, bottom, left);

    double old_value_of_x = x_org + (x_coord[0]  - x_min)* x_scale;

    double old_value_of_y = bottom - (y_coords[0][0]  - y_min)* y_scale;



    for (int i=1; i<num_points; i++) {


        double x = x_org + (x_coord[i]  - x_min)* x_scale;


        double y =  bottom - (y_coords[0][i]  - y_min)* y_scale;


        my_window->plot_line((int)old_value_of_x, (int)old_value_of_y, (int)x, (int)y);


        old_value_of_x = x;


        old_value_of_y = y;

    }

    my_window->plot_line(left, bottom, left, bottom+4);

    my_window->plot_line(right, bottom, right, bottom+4);

    my_window->plot_line(left, bottom, left-4, bottom);

    my_window->plot_line(left, top, left - 4, top);

    char buf[32];

    sprintf(buf,"%6.1f",x_min); 

    my_window->plot_string(left - (my_window->string_width(buf) / 2), bottom + 19, buf);

    sprintf(buf,"%6.1f",x_max); 

    my_window->plot_string(right - (my_window->string_width(buf) / 2), bottom + 19, buf);

    sprintf(buf,"%6.1f",y_min); 

    my_window->plot_string(left -  my_window->string_width(buf) - 4, bottom + 5, buf);

    sprintf(buf,"%6.1f",y_max); 

    my_window->plot_string(left -  my_window->string_width(buf) - 4, top + 5, buf);

    int pixel_len = my_window->string_width(my_title);

    int mid_x_pos = (left + right) / 2;

    int x_start = mid_x_pos - (pixel_len / 2);

    my_window->plot_string(x_start, top - my_window->string_height(" ") - 2, my_title);
}
