// File: textbr.cp
//
// Description: Free Text Browser Application.
//              This demo uses the TextInd Class
//

#include "applib.h"
#include "textind.h"
#include "char_v.h"

TextIndex *ti = 0;

void TAppWindow::idle_proc() {}

void TAppWindow::update_display()
{
}

void TAppWindow::mouse_down(int x, int y)
{
}

void TAppWindow::mouse_up(int, int)
{
}

void TAppWindow::mouse_move(int x, int y)
{
}

extern "C" {
   void exit(int);
};

void TAppWindow::do_menu_action(int item_number)
{
    if (item_number == 1) { // Load existng index
        char file_name[256];  file_name[0] = '\0';
        if (choose_file_to_read("Load existing index:", "idx", file_name))
            Warning("Error opening file");
         else
            ti = new TextIndex(file_name);
    }
    if (item_number == 2) { // Add a text file to the current index
        if (ti == (TextIndex *)0) {  // We need to create a new index
            char file_name[256];
            if (choose_file_to_read("Choose a text file to add:", "txt", file_name))  // Note: may want to use "" for extension
                Warning("Could not open file");
             else {
                char *fileList[1];
                fileList[0] = file_name;
                ti = new TextIndex(fileList,1);
            }
        }  else  {  // Add to existing in-memory index
            // NOTE: need to break method TextIndex::buildIndex into 2 methods
            // (i.e., buildIndex() and buildIndex_helper(char *single file name) )
        }
    }
    if (item_number == 3) { // Save the current index
        char output_file[256];
        if (choose_file_to_write("Enter output file:", output_file))
           Warning("Could not open output file");
         else {
            // TBD: make sure this file name ends with "idx"
            //  . . .
            ti->save(output_file);
        }
    }
    if (item_number == 4) { // Word Search
        if (ti != 0) {
            char target_word[256], buf[256];  target_word[0] = '\0';
            do_edit("Enter the search word:", target_word);
            char **s = ti->regionTextBlocks(target_word);
            if (s != (char **)0)  {
                int count = 0;
                while (s[count] != (char *)0) {
                    count++;
                }
                int user_selection = choose_one_from_list("Choose..",s,count);
                free_strings(s);
                int file, block;
                if (ti->regionIndex(user_selection, file, block)) {
                    sprintf(buf,"file=%d, block=%d",file,block);
                    put_scrolling_text(buf);
cerr << buf << "\n";
                    char *buf2 = new char[BLOCK_SIZE + 2];
                    ti->get_text(buf2,BLOCK_SIZE,file,block);
                    int text_len = strlen(buf2);
                    for (int j=0; j<(text_len - 20); j++) {
                        int eol_flag = 0;
                        for (int l=0; l<255; l++) buf[l] = '\0';
                        for (int i=j; i<text_len; i++) {
                            if ((i-j) < 254) {
                                buf[i-j] = buf2[i];
                                if (buf2[i] < 30) {
                                    buf[i-j] = '\0';
                                    j = i;
                                    eol_flag = 1;
                                    break;
                                }
                            }
                        }
                        if (eol_flag == 0) {
                            delete buf2;
                            return;
                        }
                        if (strlen((char *)buf) < 255) {
cerr << "text: " << buf << "\n";
                            put_scrolling_text(buf);
                        }
                    }
                    delete buf2;
                }
            }
        } else
            Warning("No active index");

    }
    if (item_number == 5)                  exit(0);
}

static char * menu_items[] = {
	"Load existing index file",
        "Add text to current index",
        "Save current index to file",
        "WORD SEARCH",
        "QUIT"};

INIT_PROGRAM("Text browser", 5, menu_items)

   // anything can go here
   current_window->init_scrolling_text();
   current_window->put_scrolling_text("Text Indexer/Browser Application");
   
   RUN_PROGRAM;
}
