// File: test.cp

#include "applib.h"
#include "grapher.h"
#include "tplot.h"

// Main program:

static char *m_titles[] ={"Test Grapher","Test Edit box",
                          "Test Info box","Single list test",
                          "Test choose 1 of 2", "Test scrolling text",
                          "Test data plotting","Quit    "};

INIT_PROGRAM("Test program", 8, m_titles)

// anything can go here

RUN_PROGRAM;
}

//  USER DEFINED CALLBACK(S):

// for testing:

static int nump = 0;
static int xx[10], yy[10];

static TGraph *my_graph = (TGraph *)NULL;
static TPlotClass *tp = (TPlotClass *)NULL;
static TPlotClass *tp2= (TPlotClass *)NULL;

static char my_text[256];

void TAppWindow::update_display()
{

    if (my_graph != (TGraph *)NULL)
        my_graph->Draw();

    if (tp != (TPlotClass *)NULL)
        tp->plot();

    if (tp2!= (TPlotClass *)NULL)
        tp2->plot();

    for (int i=0; i<nump; i++) {
        plot_line(xx[i], yy[i], xx[i]+10, yy[i]+10);
        char buf[22];
        sprintf(buf,"%d",i);
        plot_string(xx[i], yy[i] - 15, buf);
    }
    plot_string(40, 60, my_text);
}

void TAppWindow::mouse_down(int x, int y)
{
    if (nump < 9) {
        xx[nump] = x;
        yy[nump] = y;
        nump++;
    }
}

void TAppWindow::mouse_up(int, int)
{
}

void TAppWindow::mouse_move(int, int)
{
}

void TAppWindow::idle_proc()
{
#if 0
    static int counter = 0;
    sprintf(my_text,"%d",counter++);
    erase_rect(30, 130, 100, 10);
    update_display();
#endif
}

void TAppWindow::do_menu_action(int item_number)
{

    if (item_number == 1) {
        nump = 0;
        my_graph = new TGraph(this, "A");
        my_graph->test();
  //      clear_display();
        update_display();
    }

    if (item_number == 2) {
        sprintf(my_text,"this is a test.              ");
        do_edit("Prompt:", my_text);
    }

    if (item_number == 3) show_info("Test application...");

    if (item_number == 4)  {
        static char *sel_list[] =
    {"option 0", "element 1", "this is choice number 2", "pick 3"};

        int ii = choose_one_from_list("Choose something...",sel_list,4);
        char buf2[255];
        sprintf(buf2,"item selected = %d", ii);
        Warning(buf2);
    }

    if (item_number == 5)  {
        int ii = choose_one("0", "1");
        char buf2[255];
        sprintf(buf2,"item selected = %d", ii);
        Warning(buf2);
    }

    if (item_number == 6)  {
        static int need_to_init_text = 1;
        if (need_to_init_text) {
            need_to_init_text = 0;
            init_scrolling_text(20, 180, 180, 33);
            init_scrolling_text();
        }
        static int countit = 0;
        static char buf2[256];
        sprintf(buf2,"This is a test %d     1234567890123456789012345678901234567890123456789012345678901234567890",countit++);
        put_scrolling_text(buf2);
    }

    if (item_number == 7)  {
        static double xp[30];
        static double yp[30];
        for (int i=0; i<30; i++) {
            double x = i - 12;
            double y = 0.2*x*x*x*x*x - 4.0 * x*x*x*x
                + 11.0 * x*x*x - 5.0*x*x - 7;
            xp[i] = x;
            yp[i] = y;
        }
        tp = new TPlotClass(current_window,"Little plot",xp,yp,30,
                            50,280,140,40);

        tp2= new TPlotClass(current_window,"BIG plot",xp,yp,30,
                            160,450,450,90);

   //     clear_display();
        update_display();
    }
    if (item_number == 8)  exit(0);
}
