// File: int_vect.cp
//
// Description: This file implements the int smart vector class
//
// Copyright 1992 by Mark Watson Associates
//
//       No binary rights reserved: this software library may be used in
//       compiled form without restrictions.  All source rights
//       reserved: Source code to the GUI library can not be distributed
//       (on bulletin boards, or as part of shareware or commercial products)
//       without written permission.
//
//       This software is provided "as is". The user accepts all
//       responsibility for its use.
//

#include "int_vect.h"

extern "C" { void exit(int); };

extern void Warning(char *);

// Define constants for the dynamic grow rate for int_vect data types and
// the maximum number of elements that a smart int_vect can have:

const int GROW_RATE = 1;
const int MAX_SIZE = 5000;

int_vect::int_vect(void)
{

num_elements = 0;

size = 10;

p = new int[size];
}

int_vect::int_vect(int n)
{

if (n<= 0) {


Warning("illegal size for a int_vect");


exit(1);

}

num_elements = 0;

size = n;

p = new int[size];
}

int_vect::int_vect(int a[], int n)
{

if (n<= 0) {


Warning("illegal size for a int_vect");


exit(1);

}

num_elements = size = n;

p = new int[size];

for (int i=0; i<size; i++)  p[i] = a[i];
}

int_vect::int_vect(int_vect &v)
{

size = v.size;

p = new int[size];

for (int i=0; i<size; i++)  p[i] = v.p[i];

num_elements = size;
}

int & int_vect::operator [] (int i)
{

if (i < 0) {


Warning("illegal index for int_vect");


exit(1);

}

if (i > ub()) {


grow(i);

}

if ((i + 1) > num_elements)  num_elements = i+1;

return (p[i]);
}

void int_vect::grow(int new_size)
{

if ((new_size + GROW_RATE) >= MAX_SIZE) {


Warning("error in dynamic resizing of a smart int_vect");


exit(1);

}

int *np = new int[(new_size + GROW_RATE)];

for (int i=0; i<size; i++)  np[i] = p[i];

delete p;

size = (new_size + GROW_RATE);

p = np;
}

void int_vect::save(char *file_name)
{

filebuf out_file;

if (out_file.open(file_name, output)==0) {


Warning("Could not open output file for int vect save");


exit(1);

}

ostream out_stream(&out_file);

out_stream << num_elements << "\n";

for (int i=0; i<num_elements; i++)


out_stream << p[i] << "\n";

out_file.close();
}

void int_vect::restore(char *file_name)
{

filebuf in_file;

if (in_file.open(file_name, input)==0) {


Warning("Could not open input file for int vect restore");


exit(1);

}

istream in_stream(&in_file);

in_stream >> size;

num_elements = size;



if (size > ub()-1)  grow(size);

for (int i=0; i<num_elements; i++)


in_stream >> p[i];

in_file.close();
}

#if 0

// test code:

main()
{

cerr << "Start of int_vect test:\n\n";

int_vect vv(10);

vv[2] = 2;

vv[220] = vv[2];  // illegal index !!

cerr << "Done with test.\n";
}

#endif
