//
// File: Grapher.h
//
// Description:  Grapher utility include file
//
// Copyright 1992 by Mark Watson Associates
//
//       No binary rights reserved: this software library may be used in
//       compiled form without restrictions.  All source rights
//       reserved: Source code to the GUI library can not be distributed
//       (on bulletin boards, or as part of shareware or commercial products)
//       without written permission.
//

#ifndef Grapher_Defs
#define Grapher_Defs

#include "applib.h"

#define MAX_NODES 40

#define TEXT_SIZE 20

typedef struct _node {

char name[20];

int x, y;

int parent_id;

int plot_node; // used for sub-tree displays

char *private_data;  // used for application data

int selectionFlag; // 0=not selected, 1=a child node is selected,
} node;                         // 2=this node selected, 3=a parent node is selected

typedef struct _tree {

node nodes[MAX_NODES];

int num;

int parent_node;
} tree;

class TGraph {
  public:

TGraph(TAppWindow * myWind, char * root_name);

void add_child(char *name, char * parent);

int name_to_id(char *name);

void do_layout();

void do_layout(int new_parent_node);

void test();

void Draw();



TAppWindow *myWindow;



void setSelection(int node_id); // node_id=-1 for clear whole graph

int closestNode(int x, int y);

int TGraph::getSelectedNode();

tree t;
  private:

int last_y;

void init_tree(char *root_name);

int get_children(char *name, int *child_list, int buf_size);

void Y_layout(int node_id, int level);

void X_layout(int node_id, int level);

void set_selection_children(int node_id);

void set_selection_parent(int node_id);

void clear_display();

void plot_line(int, int, int, int);

void plot_string(int, int, char *);
};

#endif
