// File: draw.cp
//
// Description: Example Drawing program using the C++ GUI
//
// Copyright 1992 by Mark Watson Associates
//
//       No binary rights reserved: this software library may be used in
//       compiled form without restrictions.  All source rights
//       reserved: Source code to the GUI library can not be distributed
//       (on bulletin boards, or as part of shareware or commercial products)
//       without written permission.
//

#include "applib.h"     // C++ GUI library include file
#include "int_vect.h"   // Use smart vector to store points

int nump = 0;           // count the number of points stored
int_vect points(99);    // stored as: (x, y, pen_up_or_down) triples

#define X(n) (3*(n))
#define Y(n) (3*(n)+1)
#define UP_OR_DOWN(n) (3*(n)+2)

void TAppWindow::update_display() // draw all the saved points
{
    for (int i=0; i<nump - 1; i++) {


if (points[UP_OR_DOWN(i)])



plot_line(points[X(i)], points[Y(i)],



          points[X(i+1)], points[Y(i+1)]);

}
}

void TAppWindow::mouse_down(int xp, int yp)
{

points[X(nump)] = xp;  // smart vectors grow dynamically and

points[Y(nump)] = yp;  // abort the program on insufficient memory

points[UP_OR_DOWN(nump)] = 0;

nump++;
}

void TAppWindow::mouse_up(int xp, int yp)  // AND mouse move logic
{

points[X(nump)] = xp;  // smart vectors grow dynamically

points[Y(nump)] = yp;  // and abort the program on insufficient memory

points[UP_OR_DOWN(nump)] = 1;

if (nump > 1) 


plot_line(points[X(nump-1)], points[Y(nump-1)],


          points[X(nump)], points[Y(nump)]);

nump++;
}

void TAppWindow::mouse_move(int xp, int yp)
{

mouse_up(xp, yp);  // same functionality as mouse up event
}

void TAppWindow::idle_proc() { }  // no background processing necessary

void TAppWindow::do_menu_action(int item_number)
{   char buf[80], file_name[256];

if (item_number == 1) {  // reset drawing


nump = 0;


clear_display();

}

if (item_number == 2) {  // save to a file


if (choose_file_to_write("Save file (end in .drw)", file_name))



Warning("Error opening file");


 else  points.save(file_name);

}

if (item_number == 3) {  // reload points from a file


if (choose_file_to_read("Restore file", "drw", file_name))



Warning("Error opening file");


 else  { points.restore(file_name);  nump = points.num_elements / 3;


 


 }

}
}

static char *m_titles[] ={"Clear","Save to file",
                          "Reload from file"};

INIT_PROGRAM("Draw", 3, m_titles)

   // anything can go here
   
   RUN_PROGRAM;
}

