// File: double_v.h
//
// Description:  smart double vector
//
// Copyright 1992 by Mark Watson Associates
//
//       No binary rights reserved: this software library may be used in
//       compiled form without restrictions.  All source rights
//       reserved: Source code to the GUI library can not be distributed
//       (on bulletin boards, or as part of shareware or commercial products)
//       without written permission.
//

#ifndef __double_vect
#define __double_vect

#include <fstream.h>

#define input (ios::in)
#define output (ios::out)

class double_vect {
    double *p;
    int size;
    void grow(int new_size);
    int ub() { return (size - 1); }
  public:
    double_vect(void);
    double_vect (int n);
    double_vect(double_vect &v);
    double_vect(double a[], int n);
   ~double_vect() { delete p; }
    double & operator [] (int i);  // range check safeguards
    void save(char *filename);
    void restore(char *filename);
};

#endif

