// File: char_v.h
//
// Description: smart character vector
//
// Copyright 1992 by Mark Watson Associates
//
//       No binary rights reserved: this software library may be used in
//       compiled form without restrictions.  All source rights
//       reserved: Source code to the GUI library can not be distributed
//       (on bulletin boards, or as part of shareware or commercial products)
//       without written permission.
//

#ifndef __char_vect
#define __char_vect

#include <iostream.h>
#include <fstream.h>
#include "apptypes.h"

#define output (ios::out)
#define input (ios::in)

class char_vect {
    Long size;
    void grow(Long new_size);
    Long ub() { return (size - 1); }
  public:
    Char *p;
    char_vect(void);
    char_vect (long n);
    char_vect(char_vect &v);
    char_vect(Char a[], long n);
   ~char_vect() { delete p; }
    Char & operator [] (long i);  // range check safeguards
    void save(char *filename);
    void restore(char *filename);
};

#endif
