// File: char_v.cp
//
// Description: smart vector implementation for characters
//
// Copyright 1992 by Mark Watson Associates
//
//       No binary rights reserved: this software library may be used in
//       compiled form without restrictions.  All source rights
//       reserved: Source code to the GUI library can not be distributed
//       (on bulletin boards, or as part of shareware or commercial products)
//       without written permission.
//

#include "char_v.h"

extern "C" { void exit(int); };

// Define constants for the dynamic grow rate for char_vect data types and
// the maximum number of elements that a smart char_vect can have:

const int GROW_RATE = 4096;
const int MAX_SIZE = 1048576;

char_vect::char_vect(void)
{
    size = 32768;
cerr << "In Char_vect default constructor, size=" << size << "\n";
    p = new char[size];
}

char_vect::char_vect(long n)
{
    if (n<= 0) {
        cerr << "illegal size for a char_vect = " << n << "\n";
        exit(1);
    }
    size = n;
    p = new char[size];
}

char_vect::char_vect(Char a[], long n)
{
    if (n<= 0) {
        cerr << "illegal size for a char_vect = " << n << "\n";
        exit(1);
    }
    size = n;
    p = new char[size];
    for (long i=0; i<size; i++)  p[i] = a[i];
}

char_vect::char_vect(char_vect &v)
{
    size = v.size;
    p = new char[size];
    for (long i=0; i<size; i++)  p[i] = v.p[i];
}

Char & char_vect::operator [] (long i)
{
    if (i < 0) {
        cerr << "illegal index for char_vect = " << i << "\n";
        exit(1);
    }
    if (i > ub()) {
        grow(i);
    }
    return (p[i]);
}

void char_vect::grow(long new_size)
{
    if ((new_size + GROW_RATE) >= MAX_SIZE) {
        cerr << "error in dynamic resizing of a smart char_vect, new size = "
             << (new_size + GROW_RATE) << "\n";
        exit(1);
    }
    Char *np = new Char[(new_size + GROW_RATE)];
    for (long i=0; i<size; i++)  np[i] = p[i];
    delete p;
cerr << "growing a char_vect: old size = " << size << "  new size= "
<< (new_size + GROW_RATE) << "\n";
    size = (new_size + GROW_RATE);
    p = np;
}

void char_vect::save(char *file_name)
{
    filebuf out_file;
    if (out_file.open(file_name, output)==0) {
//      cerr << "Could not open output file " << file_name << "\n";
        exit(1);
    }
    ostream out_stream(&out_file);
    out_stream << size << "\n";
    for (long i=0; i<size; i++)
        out_stream << p[i] << "\n";
    out_file.close();
}

void char_vect::restore(char *file_name)
{
    filebuf in_file;
    if (in_file.open(file_name, input)==0) {
//      cerr << "Could not open input file " << file_name << "\n";
        exit(1);
    }
    istream in_stream(&in_file);
    in_stream >> size;
    for (long i=0; i<size; i++)
        in_stream >> p[i];
    in_file.close();
}

#if 0

// test code:

void main()
{
    cerr << "Start of char_vect test:\n\n";
    char_vect vv;
    for (long l=0; l<256000; l++) vv[l] = (char)(l % 128);
    for (l=0; l<256000; l++)
        if (vv[l] != (char)((l % 128)))  cerr << "Error " << l << "\n";
    cerr << "Done with test.\n";
}

#endif
