// File: applib.h
//
// Description: Header file for X Window GUI library
//
// Copyright 1992 by Mark Watson Associates
//
//       No binary rights reserved: this software library may be used in
//       compiled form without restrictions.  All source rights
//       reserved: Source code to the GUI library can not be distributed
//       (on bulletin boards, or as part of shareware or commercial products)
//       without written permission.
//

#ifndef __applib
#define __applib

#include <iostream.h>
#include <fstream.h>

#include <string.h>
#include <stdlib.h>
#include <dirent.h>

#if 0
extern "C" {
//#include <string.h>
    int strcpy(char *, char *);
    int strlen(char *);
    int strcmp(char *, char *);
};
#endif

#define FUNCPROTO 1
#define __cplusplus 1
#define NeedFunctionPrototypes 1
#define XTFUNCPROTO 1

extern "C" { void exit(int); };

#define class Xclass
#define type Xtype
#define new Xnew
#define altzone Xaltzone
#define XtMainLoop XXtMainLoop
#define output XXoutput
#define input XXinput
 
#include <Xlib.h>
#include <StringDefs.h>
#include <Intrinsic.h> 
#include <cursorfont.h>
#include <X.h>
#include <Command.h>
// #include <VPaned.h>
#include <List.h>
#ifndef MOTIF
#include <Form.h>
#include <Dialog.h>
#include <Shell.h>
#include <Box.h>
#include <Text.h>
#include <Label.h>
#endif
#ifdef MOTIF
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/Text.h>
#endif


#undef class
#undef type
#undef new
#undef altzone
#undef XtMainLoop
#undef input
#undef output

extern "C" {
    void XtMainLoop();
#include <stdio.h>
};

GC createXorGC(Widget);
GC createCopyGC(Widget);

typedef struct {
    int start_x, start_y, last_x, last_y;
    GC  gc;
  } mouse_data;

void do_make_menu(Widget w, int client_data, int call_data);
void start_mouse(Widget, mouse_data *, XEvent *event);
void track_mouse(Widget, mouse_data *, XEvent *event);
void end_mouse(Widget, mouse_data *, XEvent *event);
void draw_screen(Widget, caddr_t, caddr_t);

const int MAX_TEXT_LINES = 32;
const MAX_TEXT_LINE_SIZE = 100;

class TAppWindow {
 public:

    int string_height(char *) { return 13; }
    int string_width(char *str) { return 7 * strlen(str); }
    // To support scrolling text:
        short top_text_clip, right_text_clip, bottom_text_clip, left_text_clip;
    char *saved_text[MAX_TEXT_LINES];  // This is a ring-buffer
    int number_of_saved_lines;
    int current_ring_buffer_start;
    // We only allow either text or graphics to be active in a document window.
    // The following flag is non-zero if we are using the document window for scrolling text.
    // Note that this mode changes automatically when either plotting or scrolling text
    // output methods are called.
    int in_scrolling_text_mode;
    // The following flag indicates that a small scrolling text field is being used
    // so we want to update both graphics and text. Note that this only looks good if
    // the application program is careful to not draw in the scrolling text area.
    int redraw_both_text_and_graphics;
    
        
    void init_scrolling_text(int top, int right, int bottom, int left);
    void init_scrolling_text();
    void put_scrolling_text(char *str);
    void reset_scrolling_text();

    // Graphics support:
    void plot_line(int, int, int, int);
    void plot_string(int, int, char *);
    void plot_rect(int top, int right, int bottom, int left);
    void erase_rect(int top, int right, int bottom, int left);
    void clear_display();  // Forces a redraw of window calling user

    void do_edit(char *, char *);
    void show_info(char *);
    int choose_one(char *prompt1, char *prompt2);
    int choose_one_from_list(char *prompt, char **list_items,
                             int number_of_items);
    int choose_file_to_read(char *prompt, char *extension, char *file_name);
    int choose_file_to_write(char *prompt, char *file_name);


    // user specified methods:
    void mouse_down(int, int);
    void mouse_up(int, int);
    void mouse_move(int, int);
    void do_menu_action(int);
    void update_display();

    // Idle work method (this method should return quickly when called)
    void idle_proc();
};

void makeMenu(Widget, char **, int);
void set_enter_widget_callback(Widget, XtActionProc );
void Warning(char *);

#ifndef MOTIF
#define LABEL labelWidgetClass
#define FORM formWidgetClass
#define COMMAND commandWidgetClass
#else
#define LABEL xmLabelWidgetClass
#define FORM xmFormWidgetClass
#define COMMAND xmPushButtonWidgetClass
#endif

#ifdef MOTIF
#define MAKE_MENU(menu_title, num_items, items) \
                      Widget control_area;\
                      control_area=XtCreateManagedWidget("controls",\
                           xmBulletinBoardWidgetClass,global_form,NULL,0);\
                      Widget menubar;\
                      n = 0;\
                      menubar = XmCreateMenuBar(control_area,"menubar",\
                                                args,n);\
                      XtManageChild(menubar); \
                      makeMenu(menubar, items, num_items);\
                      XtRealizeWidget(toplevel);
#else
#define MAKE_MENU     XtRealizeWidget(toplevel);\
                      n = 0;\
                      XtSetArg(args[n],XtNy,3); n++;\
                      XtSetArg(args[n],XtNx,3); n++;\
                      XtSetArg(args[n],XtNborderWidth,3); n++;\
                      menu = XtCreateManagedWidget(" Menu ", \
                                                   commandWidgetClass, \
                                                   global_form, args, n);\
                      XtAddCallback(menu,XtNcallback,\
                                    (XtCallbackProc)do_make_menu,\
                                    (XtPointer)NULL);

#endif

#define output (ios::out)
#define input (ios::in)

int do_work();

extern TAppWindow *current_window;

void set_menu(char *, int, char **);
extern Widget global_form;

#define INIT_PROGRAM(menu_title, num_items, items) \
TAppWindow currentAppWindow;\
mouse_data data;\
Widget global_form, dWidget;\
main(int argc, char **argv)\
{\
  Widget toplevel, menu;\
  Arg args[10];\
  int n;\
  set_menu(menu_title, num_items, items); \
  toplevel = XtInitialize(argv[0], "main", NULL, 0, \
                          &argc, argv);\
  n = 0;\
  XtSetArg(args[n],XtNborderWidth,0); n++;\
  global_form = XtCreateManagedWidget("global_form", FORM, \
                               toplevel, args, n);\
  n = 0;\
  XtSetArg(args[n],XtNy,40); n++;\
  XtSetArg(args[n],XtNwidth,390); n++;\
  XtSetArg(args[n],XtNheight,350); n++;\
  XtSetArg(args[n],XtNborderWidth,0); n++;\
  dWidget = XtCreateManagedWidget("  ", \
                                 LABEL, \
                                 global_form, args, n);\
  XtAddEventHandler(dWidget, ExposureMask, 1, (XtEventHandler)draw_screen,\
                     (XtPointer)NULL);\
  XtAddEventHandler(dWidget, ButtonPressMask, FALSE,\
                    (XtEventHandler)start_mouse, (XtPointer)&data);\
  XtAddEventHandler(dWidget, ButtonMotionMask, FALSE,\
                    (XtEventHandler)track_mouse, (XtPointer)&data);\
  XtAddEventHandler(dWidget, ButtonReleaseMask,\
                    FALSE, (XtEventHandler)end_mouse, (XtPointer)&data);\
  MAKE_MENU(menu_title, num_items, items) ; \
  XGrabButton(XtDisplay(dWidget), (unsigned int)AnyButton, AnyModifier, \
              XtWindow(dWidget), TRUE, \
              (unsigned int)(ButtonPressMask | ButtonMotionMask | \
              ButtonReleaseMask) ,\
              GrabModeAsync, GrabModeAsync,\
              XtWindow(dWidget), \
              XCreateFontCursor(XtDisplay(dWidget),\
                                XC_crosshair));\
  data.gc = createCopyGC((Widget)dWidget); \
  current_window = &currentAppWindow;\
//  XtAddWorkProc((XtWorkProc)do_work, NULL);

#define RUN_PROGRAM \
  XtMainLoop();


#endif


